@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}">

    <div class="row">
        <div class="col-12">
            <div class="card">
                <!-- Card header -->
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">HashTag</h5>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                                <button class="btn btn-outline-dark sub_chk_all"> Select All </button>
                                <div class="dropdown d-inline " style="margin-right:10px;">
                                    <a href="javascript:;" class="btn btn-outline-dark dropdown-toggle "
                                        data-bs-toggle="dropdown" id="navbarDropdownMenuLink2">
                                        Action
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3"
                                        aria-labelledby="navbarDropdownMenuLink2" data-popper-placement="left-start">
                                        <li><a class="dropdown-item border-radius-md" href="javascript:;" id="enable"
                                                data-id="hashtag">Eanble</a></li>
                                        <li><a class="dropdown-item border-radius-md" href="javascript:;" id="disable"
                                                data-id="hashtag">Disable</a></li>
                                    </ul>
                                </div>
                                <a href="#" class="btn bg-gradient-info btn-sm mb-0 addTag">+&nbsp; ADD NEW</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body px-0 pb-0">
                    <div class="table-responsive">
                        @if ($errors->get('msgError'))
                            <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                                <span class="alert-text text-white">
                                    {{ $errors->first() }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                        @endif
                        @if (session('success'))
                            <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success"
                                role="alert">
                                <span class="alert-text text-white">
                                    {{ session('success') }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                        @endif
                        <table class="table table-flush" id="data-list">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>#Tag</th>
                                    <th>Category</th>
                                    <th>TOTAL NOVEL ON HASHTAG</th>
                                    <th>STATUS</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (count($data) > 0)
                                    @foreach ($data as $item)
                                        <tr id="{{ $item->id }}">
                                            <td class="text-sm">
                                                <div class="form-check my-auto">
                                                    <input class="form-check-input sub_chk" type="checkbox"
                                                        id="customCheck1" data-id="{{ $item->id }}"
                                                        value="{{ $item->id }}">
                                                </div>
                                            </td>
                                            <td class="text-sm">#{{ $item->title }}</td>
                                            <td class="text-sm"><span class="badge bg-info">{{ $item->catName }}</span></td>
                                            <td class="text-sm">0</td>
                                            <td class="text-sm">
                                                @if ($item->status == 0)
                                                    <span class="badge bg-success">Active</span>
                                                @else
                                                    <span class="badge bg-danger">Disabled</span>
                                                @endif
                                            </td>
                                            <td class="text-sm">

                                                <a href="#" class="mx-3 editTag" id="{{ $item->id }}"
                                                    data-bs-toggle="tooltip" data-bs-original-title="Edit">
                                                    <i class="fas fa-edit text-success"></i>
                                                </a>

                                                <a href="#" data-id="hashtag" id="{{ $item->id }}"
                                                    class="mx-3 delete" data-bs-toggle="tooltip"
                                                    data-bs-original-title="Delete">
                                                    <i class="fas fa-trash text-danger"></i>
                                                </a>

                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr> no content </tr>
                                @endif
                            </tbody>
                        </table>

                        {{ $data->links('components.paginate') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Add Start --}}

    <div class="modal fade" id="tagModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalMessageTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add Tag</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa fa-close">×</i>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="/novel/tag/store" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label for="recipient-name" class="form-label">Tag Category</label>
                            <select name="cat" id="cat" class="form-control" required>
                                @foreach ($cat as $item)
                                   <option value="{{$item->id}}">{{$item->title}}</option> 
                                @endforeach        
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="recipient-name" class="form-label">Tag Title { add multiple hastag with like
                                drama,sweet}</label>
                            <input type="text" class="form-control" name="title" placeholder="drama,sweet"
                                required>
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn bg-gradient-info">ADD</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Add End --}}

    {{-- Modal Update Start --}}

    <div class="modal fade" id="tagupdateModal" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalMessageTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update HashTag</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="fa fa-close">×</i>
                    </button>
                </div>
                <div class="modal-body">
                    <form action="/novel/tag/update" method="POST" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="id" id="tag_id" />

                        <div class="form-group">
                            <label for="recipient-name" class="form-label">Tag Category</label>
                            <select name="cat" id="catup" class="form-control" required>
                                @foreach ($cat as $item)
                                    <option value="{{$item->id}}">{{$item->title}}</option> 
                                @endforeach   
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="recipient-name" class="form-label">Tag Title { add multiple hastag with like
                                drama,sweet}</label>
                            <input type="text" class="form-control" name="title" id="tag_title" placeholder="drama,sweet"
                                required>
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn bg-gradient-info">Save Changes</button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Update End --}}

@endsection
@push('js')
    <script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
    <script src="../../assets/js/plugins/sweetalert.min.js"></script>
    <script src="../../assets/js/plugins/action.js"></script>
    <script>
        if (document.getElementById('data-list')) {
            const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
                searchable: true,
                fixedHeight: true,
                perPage: 15,
                labels: {
                    placeholder: "Search...",
                    perPage: "Show {select} entries",
                    noRows: "No entries found",
                    info: "Showing {{ $data->firstItem() }} to {{ $data->lastItem() }} of {{ $data->total() }} entries"
                },
            });


        };
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);
        });

        $("body").on("click", ".addTag", function() {
            $("#tagModal").modal('show');
        });

        $("body").on("click", ".editTag", function() {
            var current_object = $(this);
            var link = window.location.origin;
            id = current_object.attr('id');
            $.ajax({
                url: '/novel/tag/edit/' + id,
                type: "GET",

                success: function(data) {
                    $("#tagupdateModal").modal('show');
                    $("#tag_id").val(data['id']);
                    $("#tag_title").val(data['title']);

                    $('#catup option[value="' + data['cat'] + '"]').attr("selected", "selected");
                },
            });
        });
    </script>
@endpush
