@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
          <div>
            <h5 class="mb-0">Stories</h5>
            <div class=" mt-3">
                <div class="row">
                  <div class="col-sm-4">
                    <select class="form-control"  onchange="javascript:location.href = this.value;">
                      <option value="/story?cat=all" {{ (request()->get('cat') == 'all' ) ? 'selected' : ''}} >All Category</option>
                      @foreach ($cat as $item)
                        <option value="/story?cat={{$item->id}}" {{ (request()->get('cat') == $item->id ) ? 'selected' : ''}} >{{$item->title}}</option>
                      @endforeach
                    </select>
                  </div> 
                  <div class="col-sm-3"> </div>  
                  <div class="col-sm-5">
                  
                  <div class="float-end">
                      <button class="btn btn-outline-dark sub_chk_all"> Select All </button>
                      <div class="dropdown d-inline " style="margin-right:10px;">
                        <a href="javascript:;" class="btn btn-outline-dark dropdown-toggle " data-bs-toggle="dropdown" id="navbarDropdownMenuLink2">
                          Action
                        </a>
                        <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3" aria-labelledby="navbarDropdownMenuLink2" data-popper-placement="left-start">
                          <li><a class="dropdown-item border-radius-md" href="javascript:;" id="enable" data-id="story">Eanble</a></li>
                          <li><a class="dropdown-item border-radius-md" href="javascript:;" id="disable" data-id="story">Disable</a></li>
                        </ul>
                      </div>
                      <a href="/story/add" class="btn bg-gradient-info btn-lg">+&nbsp; ADD NEW</a>
                    </div>
                  </div>
                </div>
            </div>
         
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>#</th>
                <th>THUMBNAIL</th>
                <th>TITLE</th>
                <th>VIEWS</th>
                <th>CATEGORY</th>
                <th>STATUS</th>
                <th>CREATED AT</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              @if(count($data) > 0)
              @foreach($data as $item)
              <tr id="{{$item->id}}">
                <td class="text-sm">
                  <div class="form-check my-auto">
                  <input class="form-check-input sub_chk" type="checkbox" id="customCheck1" data-id="{{$item->id}}" value="{{$item->id}}">
                  </div>
                </td>
                <td class="text-sm">
                     <span class="my-2 text-xs">
                        <img src="{{ url('/'.$item->image) }}" class="img-fluid border-radius-lg" style="height:130px;" width="200">
                    </span>
                </td>
                <td class="text-sm">{{$item->title}}</td>
                <td class="text-sm">{{$item->views}}</td>
                <td class="text-sm"><span class="badge badge-dark text-white">{{$item->catName}}</span></td>
                <td class="text-sm" >
                  @if($item->status==0)
                  <span class="badge bg-success">Published</span>
                  @else
                  <span class="badge bg-danger">Unpublished</span>
                  @endif
                </td>
                <td class="text-sm">{!!date('d-M-y H:i:s',strtotime($item->publish_date))!!}</td>
                <td class="text-sm">

                      <a href="/story/edit/{{$item->id}}" class="mx-3 " id="{{$item->id}}" data-bs-toggle="tooltip" data-bs-original-title="Edit">
                        <i class="fas fa-edit text-success"></i>
                      </a>
                   
                      <a href="#"  data-id="story"  id="{{$item->id}}"  class="mx-3 delete" data-bs-toggle="tooltip" data-bs-original-title="Delete">
                        <i class="fas fa-trash text-danger"></i>
                      </a>
                  
                </td>
              </tr>
              @endforeach
              @else
              <tr>    no content </tr>
              @endif
            </tbody>
          </table>
     
          {{$data->links('components.paginate')}}
        </div>
      </div>
    </div>
  </div>
</div>


@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>
<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found",
        info: "Showing {{ $data->firstItem() }} to {{$data->lastItem()}} of {{$data->total()}} entries"
      },
    });

  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });


</script>
@endpush