@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')
    <main class="main-content mt-1 border-radius-lg">
        <div class="container">

            @if ($errors->get('msgError'))
                <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                    <span class="alert-text text-white">
                        {{ $errors->first() }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif
            @if (session('success'))
                <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                    <span class="alert-text text-white">
                        {{ session('success') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif
            <div class="row mb-5 justify-content-center align-items-center">
                <div class="col-12">
                    <!-- Card Basic Info -->
                    <div class="card col-12 mt-4" id="basic-info">
                        <div class="card-header">
                            <h5> Update Story</h5>
                            <hr>
                        </div>
                        <div class="card-body pt-0">
                            <form action="/story/update" method="POST" enctype="multipart/form-data">
                                @csrf

                                <input type="hidden" name="id" value="{{$story->id}}"/>
                                <input type="hidden" name="oldicon" value="{{$story->image}}"/>

                                <div class="row">

                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <label for="recipient-name" class="form-label">Select Category</label>
                                            <select name="cat" id="choices-tag" class="form-control">
                                              <option value="">Select Category</option>
                                              @foreach ($cat as $item)
                                                <option value="{{$item->id}}" {{($story->cat == $item->id) ? 'selected' : ''}}>{{$item->title}}</option>
                                              @endforeach
                                            </select>
                                          </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label for="recipient-name" class="form-label">Select Story Type</label>
                                                <select name="type" id="type" class="form-control">
                                                  <option value="">Select Story Type</option>
                                                  <option value="0" {{($story->type =='0') ? 'selected' : '' }}>Text Post</option>
                                                  <option value="1" {{($story->type =='1') ? 'selected' : '' }}>Youtube Video Type</option>
                                                </select>
                                              </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-12">
                                        <label class="form-label mt-2">Story Name</label>
                                        <div class="input-group">
                                            <input class="form-control" name="title" type="text" placeholder="Werewolf" value="{{$story->title}}"
                                                required>
                                        </div>
                                    </div>
                                    
                                    <div class="col-sm-12" id="divvideo" >
                                        <label class="form-label mt-2">Youtube Video Url</label>
                                        <div class="input-group">
                                            <input class="form-control" name="video_url" type="url" placeholder="https://youtu.be/xxxxxx"
                                                >
                                        </div>
                                    </div>

                                    
                                    <div class="row  mt-4">
                                        <div class="col-sm-6">
                                            <label class="form-label ">Story Cover (Recommended Resolution: 300x300,400x400 or Square Image)</label>
                                                <div class="input-group">
                                                    <input class="form-control" id="icon" name="icon" type="file"
                                                        >
                                                </div>
                                            <div class="form-group">
                                                <div id="imgdiv" style="border-radius: 20%; padding:5px;"></div>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <label class="form-label">Story Order BY</label>
                                            <div class="input-group">
                                                <input class="form-control" name="item_order" type="number"
                                                    placeholder="0,1" value="{{$story->item_order}}">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="" id="divtext">
                                        <hr class="horizontal dark my-2">
                                        <label for="projectName" class="form-label">Story Description</label>
                                        <textarea class="ckeditor form-control" name="description">{{$story->description}}</textarea>
                                    </div> 

                                    <div class="col-sm-6">
                                        <label class="form-label">Story Publish Date</label>
                                        <div class="input-group">
                                            <input class="form-control datepicker" placeholder="Please select date" name="publish_date"   value="{{$story->publish_date}}" type="text" onfocus="focused(this)" onfocusout="defocused(this)">

                                        </div>
                                    </div>

                                    </div>

                                    <div class="">
                                        <button type="submit"
                                            class="btn bg-gradient-info btn-lg float-start mt-3 mb-0">Save</button>
                                    </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </main>
@endsection
@push('js')
    <script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script src="/assets/js/plugins/flatpickr.min.js"></script>
    <script>
    
        $(document).ready(function(){
            var st="{{$story->type}}";
            if(st==0){
                $('#divvideo').hide();
            }
        });
        
        $('#type').change(function(){
            if(this.value==1){
                $('#divvideo').show();
            }else{
               $('#divvideo').hide(); 
            }
        })
        
        if (document.querySelector('.datepicker')) {
            flatpickr('.datepicker', {
            mode: "single"
            });
        }
        
        
        if (document.getElementById('editor')) {
            var quill = new Quill('#editor', {
                theme: 'snow' // Specify theme in configuration
            });
        }
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);
            $("#imgdiv").hide();

        });

        $("#icon").change(function(e) {
            $('#imgdiv').show();
            for (var i = 0; i < e.originalEvent.srcElement.files.length; i++) {

                var file = e.originalEvent.srcElement.files[i];

                var img = document.createElement("img");
                var reader = new FileReader();
                reader.onloadend = function() {
                    img.src = reader.result;
                    img.height = 100;
                }

                reader.readAsDataURL(file);
                $('#imgdiv').html(img);

                // $("input").after(img);
            }
        });
 
    </script>
@endpush
