@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')
    <main class="main-content mt-1 border-radius-lg">
        <div class="container">

            @if ($errors->get('msgError'))
                <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                    <span class="alert-text text-white">
                        {{ $errors->first() }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif
            @if (session('success'))
                <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                    <span class="alert-text text-white">
                        {{ session('success') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif
            <div class="row mb-5 justify-content-center align-items-center">
                <div class="col-12">
                    <!-- Card Basic Info -->
                    <div class="card col-12 mt-4" id="basic-info">
                        <div class="card-header">
                            <h5> Update Slider</h5>
                            <hr>
                        </div>
                        <div class="card-body pt-0">
                            <form action="/banner/update" method="POST" enctype="multipart/form-data">
                                @csrf

                                <input type="hidden" name="id" value="{{$data->id}}"/>
                                <input type="hidden" name="oldicon" value="{{$data->image}}"/>

                                <div class="row">

                                    <div class="col-sm-12">
                                        <label class="form-label mt-2">Slider Type</label>
                                        <div class="input-group">
                                            <select name="type" id="type" class="form-control">
                                                <option value="">Slider Type</option>
                                                <option value="story" {{($data->type == 'story') ? 'selected' : ''}}>Story</option>
                                                <option value="banner" {{($data->type == 'banner') ? 'selected' : ''}}>External Banner</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div id="divstory">
                                        <div class="col-sm-12">
                                            <label class="form-label mt-2">Select Story</label>
                                            <div class="input-group">
                                                <select name="post_id" id="choices-tag" class="form-control">
                                                    <option value="">Select Story</option>
                                                    @foreach ($story as $item)
                                                        <option value="{{ $item->id }}" {{($data->post_id == $item->id) ? 'selected' : ''}}>{{ $item->title }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row" id="divbanner">
                                        <div class="col-sm-12 mt-2">
                                            <label class="form-label">Title</label>
                                            <div class="input-group">
                                                <input class="form-control" name="title" type="text"
                                                    placeholder="Title" value="{{ $item->title }}">
                                            </div>
                                        </div>

                                        <div class="col-sm-12 mt-2">
                                            <label class="form-label ">Select Image(Recommended resolution: Landscape:
                                                800x500,650x450)</label>
                                            <div class="input-group">
                                                <input class="form-control" id="icon" name="icon" type="file">
                                            </div>
                                            <div class="form-group">
                                                <div id="imgdiv" style="border-radius: 20%; padding:5px;"></div>
                                            </div>
                                        </div>

                                        <div class="col-sm-12 mt-2">
                                            <label class="form-label">External Url</label>
                                            <div class="input-group">
                                                <input class="form-control" name="link" type="text"
                                                    placeholder="http" value="{{ $item->link }}">
                                            </div>
                                        </div>

                                    </div>

                                </div>

                                <div class="">
                                    <button type="submit"
                                        class="btn bg-gradient-info btn-lg float-start mt-3 mb-0">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </main>
@endsection
@push('js')
    <script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script src="/assets/js/plugins/flatpickr.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);
            $("#imgdiv").hide();
            $('#divstory').hide();
            $('#divbanner').hide();

        });

        $("#icon").change(function(e) {
            $('#imgdiv').show();
            for (var i = 0; i < e.originalEvent.srcElement.files.length; i++) {

                var file = e.originalEvent.srcElement.files[i];

                var img = document.createElement("img");
                var reader = new FileReader();
                reader.onloadend = function() {
                    img.src = reader.result;
                    img.height = 100;
                }

                reader.readAsDataURL(file);
                $('#imgdiv').html(img);

                // $("input").after(img);
            }
        });


        $('#type').on('change', function() {
            var type = $(this).val(); // get selected value

            if (type == 'story') {
                $('#divstory').show();
                $('#divbanner').hide();
            } else {
                $('#divstory').hide();
                $('#divbanner').show();
            }
        });
    </script>
@endpush
