@extends('user_type.auth', ['parentFolder' => 'offer', 'childFolder' => ''])

@section('content')
 
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
         @if($errors->get('msgError'))
              <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                <span class="alert-text text-white">
                  {{$errors->first()}}</span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                  <i class="fa fa-close" aria-hidden="true"></i>
                </button>
              </div>
              @endif
              @if(session('success'))
              <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                <span class="alert-text text-white">
                  {{ session('success') }}</span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                  <i class="fa fa-close" aria-hidden="true"></i>
                </button>
              </div>
              @endif
        
        <div class="card card-body mt-4">
            <h6 class="mb-0">Add Admin</h6>
            <p class="text-sm mb-0">Fill Data</p>

            <form action="/admin/create" method="POST">
            @csrf
            
            <hr class="horizontal dark my-3">
            <label for="projectName" class="form-label">UserName</label>
            <input type="text" class="form-control" name="username" placeholder="John" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Email</label>
            <input type="email" class="form-control" name="email" placeholder="john@gmail.com" required>

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Password</label>
            <input type="password" class="form-control" name="password" placeholder="*****" required>

            <div class="row">
                 <div class="col-sm-12 col-lg-6">
                    <hr class="horizontal dark my-2">
                    <figure>
                        <blockquote class="blockquote">
                            <h6>
                                <p class="ps-2">Notification Permission</p>
                            </h6>
                        </blockquote>
                        <figcaption class="blockquote-footer ps-3">
                            Admin Can Send Notification if this permission enabled
                        </figcaption>
                    </figure>
                    
                    <select class="form-control" name="role_noti" required>
                        <option value="true">Enable</option>
                        <option value="false">Disable</option>
                    </select>
                </div>
                
                <div class="col-sm-12 col-lg-6">
                    <hr class="horizontal dark my-2">
                    <figure>
                        <blockquote class="blockquote">
                            <h6>
                                <p class="ps-2">Create Permission</p>
                            </h6>
                        </blockquote>
                        <figcaption class="blockquote-footer ps-3">
                            Admin Can Create All type of New Task if this permission enabled
                        </figcaption>
                    </figure>
                    
                    <select class="form-control" name="role_create" required>
                        <option value="true">Enable</option>
                        <option value="false">Disable</option>
                    </select>
                </div>
                
            </div>
            
            <div class="row">
                 <div class="col-sm-12 col-lg-6">
                    <hr class="horizontal dark my-2">
                    <figure>
                        <blockquote class="blockquote">
                            <h6>
                                <p class="ps-2">Edit Permission</p>
                            </h6>
                        </blockquote>
                        <figcaption class="blockquote-footer ps-3">
                            Admin Can Edit All Content & Task if this permission enabled
                        </figcaption>
                    </figure>
                    
                    <select class="form-control" name="role_edit" required>
                        <option value="true">Enable</option>
                        <option value="false">Disable</option>
                    </select>
                </div>
                
                <div class="col-sm-12 col-lg-6">
                    <hr class="horizontal dark my-2">
                    <figure>
                        <blockquote class="blockquote">
                            <h6>
                                <p class="ps-2">Delete Permission</p>
                            </h6>
                        </blockquote>
                        <figcaption class="blockquote-footer ps-3">
                            Admin Can Delete type of Task  if this permission enabled
                        </figcaption>
                    </figure>
                    
                    <select class="form-control" name="role_delete" required>
                        <option value="true">Enable</option>
                        <option value="false">Disable</option>
                    </select>
                </div>
                
            </div>
           
            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/admin') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Create Admin</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script>
    if (document.getElementById('editor')) {
        var quill = new Quill('#editor', {
            theme: 'snow' // Specify theme in configuration
        });
    }

    if (document.getElementById('choices-tag')) {
        var tag = document.getElementById('choices-tag');
        const example = new Choices(tag);
    }
</script>
@endpush