@extends('user_type.auth', ['parentFolder' => 'admin-setting', 'childFolder' => 'app-setting'])

@section('content')
    <link
        href="/assets/vendor/@fortawesome/fontawesome-free/css/all.min.css" rel="stylesheet">
<div class="container-fluid my-3 py-3">
  @if ($errors->get('msgError'))
  <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
    <span class="alert-text text-white">
      {{ $errors->first() }}</span>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
      <i class="fa fa-close" aria-hidden="true"></i>
    </button>
  </div>
  @endif
  @if (session('success'))
  <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
    <span class="alert-text text-white">
      {{ session('success') }}</span>
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
      <i class="fa fa-close" aria-hidden="true"></i>
    </button>
  </div> @endif

  <style>
    .after {
      content: "";
        position: absolute; height: 0; width: 0; left: 100%; top: 0; border: 20px dotted transparent; border-left: 20px
        dotted red; } </style>


    <div class="row mb-5">
        <div class="col-lg-2">
            <div class="card position-sticky top-1">
                <!--<h4>Setting Menu</h4>-->
                <div class="nav nav-pills flex-column bg-white p-3 nav-pills-custom" id="v-pills-tab" role="tablist"
                    aria-orientation="vertical">
                    <br>

                    <!--tab general Setting-->
                    <li class="nav-item" id="general-section_tab" data-bs-toggle="pill" data-bs-target="#v-pills-general"
                        type="button" role="tab" aria-controls="v-pills-general" aria-selected="true">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-general" data-scroll="" href="#general">
                                <i class="fas fa-cog"></i> &nbsp;General Setting
                            </a>
                        </div>
                        </a>
                    </li>
                    <hr style="margin:0;">

                    <!--tab share Setting-->
                    <li class="nav-item" id="sharemsg-section_tab" data-bs-toggle="pill" data-bs-target="#v-pills-sharemsg"
                        type="button" role="tab" aria-controls="v-pills-sharemsg" aria-selected="true">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-sharemsg" data-scroll="" href="#sharemsg">
                                <i class="fas fa-share-alt"></i> &nbsp;App Share Message
                            </a>
                        </div>
                        </a>
                    </li>
                    <hr style="margin:0;">

                    <!--tab onesignal Setting-->
                    <li class="nav-item" id="onesignal-section_tab" data-bs-toggle="pill"
                        data-bs-target="#v-pills-onesignal" type="button" role="tab" aria-controls="v-pills-onesignal"
                        aria-selected="false">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-onesignal" data-scroll="" href="#onesignal">
                                <i class="fas fa-bell"></i> &nbsp;One Signal Setting
                            </a>
                        </div>
                    </li>
                    <hr style="margin:0;">

                    <!--tab update checkin-->
                    <li class="nav-item" id="update-section_tab" data-bs-toggle="tab" data-bs-target="#v-pills-update"
                        type="button" role="tab" aria-controls="v-pills-update" aria-selected="false">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-update" data-scroll="" href="#update">
                                <i class="fas fa-cloud"></i> &nbsp;Update & Maintenance
                            </a>
                        </div>
                    </li>
                    <hr style="margin:0;">

                    <!--tab Api Setting -->
                    <li class="nav-item " id="api-section_tab" data-bs-toggle="tab" data-bs-target="#v-pills-api"
                        type="button" role="tab" aria-controls="v-pills-api" aria-selected="false">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-api" data-scroll="" href="#api">
                                <i class="fas fa-server"></i> &nbsp;API Setting
                            </a>
                        </div>
                    </li>
                    <hr style="margin:0;">

                    <!--tab privacy -->
                    <li class="nav-item" id="privacy-section_tab" data-bs-toggle="tab" data-bs-target="#v-pills-privacy"
                        type="button" role="tab" aria-controls="v-pills-privacy" aria-selected="false">
                        <div class="row">
                            <a class="nav-link text-sm" id="a-v-pills-privacy" data-scroll="" href="#privacy">
                                <i class="far fa-file"></i> &nbsp; Privacy Policy
                            </a>
                        </div>
                    </li>
                </div>
            </div>
        </div>

        <div class="col-lg-10 mt-lg-0 mt-4">
            <div class="tab-content" id="pills-tabContent">
                <div class="tab-content bg-white shadow p-5 rounded-3" id="v-pills-tabContent">
                    <!--tab content start form-->

                    <!--general Start------------->
                    <div class="tab-pane fade" id="v-pills-general" role="tabpanel"
                        aria-labelledby="general-section-tab">
                        <form method="post" action="/setting/update" enctype="multipart/form-data">
                            @csrf

                            <input type="hidden" name="type" value="general">

                            <figure>
                                <blockquote class="blockquote">
                                    <h5>
                                        <p class="ps-2"><b>General Setting</b></p>
                                    </h5>
                                </blockquote>
                                <figcaption class="blockquote-footer ps-1">
                                    App General setting
                                </figcaption>
                            </figure>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">App NAME</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="app_name"
                                        value="{{ $data->app_name }}" required>
                                </div>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">App Logo</label>
                                <div class="input-group">
                                    <input class="form-control" type="file" name="icon">
                                </div>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Email</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="email"
                                        value="{{ $data->email }}" placeholder="john@gmail.com">
                                </div>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Author</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="author"
                                        value="{{ $data->author }}" placeholder="John">
                                </div>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Website</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="website"
                                        value="{{ $data->website }}" placeholder="www.example.com">
                                </div>
                            </div>


                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Description</label>
                                <div class="input-group">
                                    <textarea class="ckeditior form-control" type="text" name="description">{{ $data->description }}</textarea>
                                </div>
                            </div>

                            <button type="submit" class="btn bg-gradient-info mt-3">Save</button>
                        </form>

                    </div>
                    <!--  End*------------->

                    <!--refer Start------------->
                    <div class="tab-pane fade" id="v-pills-sharemsg" role="tabpanel"
                        aria-labelledby="sharemsg-section-tab">
                        <figure>
                            <blockquote class="blockquote">
                                <h5>
                                    <p class="ps-2"><b>App Share Message</b></p>
                                </h5>
                            </blockquote>
                            <figcaption class="blockquote-footer ps-1">
                                When User share app or story this message include in share text
                            </figcaption>
                        </figure>

                        <form method="post" action="/setting/update">
                            @csrf
                            <input type="hidden" name="type" value="sharemsg">
                            <hr class="horizontal dark my-2">

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Share Message</label>
                                <textarea class="ckeditor form-control" type="text" name="sharemsg">{{ $data->sharemsg }}</textarea>
                            </div>

                            <button type="submit" class="btn bg-gradient-info mt-3">Save Changes</button>
                        </form>

                    </div>
                    <!--refer End*------------->


                    <!--Onesignal Start------------->
                    <div class="tab-pane fade " id="v-pills-onesignal" role="tabpanel"
                        aria-labelledby="onesignal-section-tab">
                        <figure>
                            <blockquote class="blockquote">
                                <h5>
                                    <p class="ps-2"><b>OneSignal Key Configuration</b></p>
                                </h5>
                            </blockquote>
                            <figcaption class="blockquote-footer ps-1">

                            </figcaption>
                        </figure>

                        <form method="post" action="/setting/update">
                            @csrf
                            <input type="hidden" name="type" value="onesignal">
                            <hr class="horizontal dark my-2">

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">One Signal App ID</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="onesignal_appid"
                                        value="{{ env('ONESIGNAL_APP_ID') }}" placeholder="xxxx">
                                </div>
                            </div>

                            <div class="col-sm-12 mt-3">
                                <label class="form-label">One Signal Rest Key</label>
                                <div class="input-group">
                                    <input class="form-control" type="text" name="onesignal_apikey"
                                        value="{{ env('ONESIGNAL_REST_API_KEY') }}" placeholder="xxxx">
                                </div>
                            </div>

                            <button type="submit" class="btn bg-gradient-info mt-3">Save Changes</button>
                        </form>

                    </div>
                    <!--onesignal End*------------->


                    <!--update Start------------->
                    <div class="tab-pane fade " id="v-pills-update" role="tabpanel"
                        aria-labelledby="update-section-tab">
                        <figure>
                            <blockquote class="blockquote">
                                <h5>
                                    <p class="ps-2"><b>Update & Maintenance Mode</b></p>
                                </h5>
                            </blockquote>
                            <figcaption class="blockquote-footer ps-1">
                                You can force user to update app and also enable maintenance mode
                            </figcaption>
                        </figure>

                        <form method="post" action="/setting/update">
                            @csrf
                            <input type="hidden" name="type" value="update">
                            <hr class="horizontal dark my-2">

                            <div>
                                <label for="categoryName" class="form-label">App Update & Maintenance Popup
                                    Show/Hide:-</label>
                                <select class="form-control" name="up_status" id="choices-tag"
                                    placeholder="Select Status" required>
                                    <option value="" selected="">SELECT STATUS</option>
                                    <option value="true" {{ $data->up_status == 'true' ? 'selected' : '' }}>ON</option>
                                    <option value="false" {{ $data->up_status == 'false' ? 'selected' : '' }}>OFF
                                    </option>
                                </select>
                            </div>

                            <hr class="horizontal dark my-2">
                            <div>
                                <label for="categoryName" class="form-label">Select Mode</label>
                                <select class="form-control" name="up_mode" id="choices-tag1" placeholder="Select Mode"
                                    required>
                                    <option value="" selected="">SELECT Mode</option>
                                    <option value="0" {{ $data->up_mode == '0' ? 'selected' : '' }}>UPDATE POPUP
                                    </option>
                                    <option value="1" {{ $data->up_mode == '1' ? 'selected' : '' }}>Maintenance
                                    </option>
                                </select>
                            </div>

                            <hr class="horizontal dark my-2">
                            <label for="projectName" class="form-label">Android App Version Code</label>
                            <input type="number" class="form-control" name="up_version" placeholder="1"
                                value="{{ $data->up_version }}" required>

                            <hr class="horizontal dark my-2">
                            <label for="projectName" class="form-label">App URL</label>
                            <input type="text" class="form-control" name="up_link" placeholder="http"
                                value="{{ $data->up_link }}">

                            <hr class="horizontal dark my-2">
                            <label for="projectName" class="form-label">Message</label>
                            <div id="editor">
                                <textarea name="up_msg" class="form-control">{{ $data->up_msg }}</textarea>
                            </div>

                            <hr class="horizontal dark my-2">
                            <div>
                                <label for="categoryName" class="form-label">User Can Skip Update</label>
                                <select class="form-control" name="up_btn" id="choices-tag2"
                                    placeholder="Select User Can Skip Update">
                                    <option value="" selected="">User Can Skip Update?</option>
                                    <option value="true" {{ $data->up_btn == 'true' ? 'selected' : '' }}>YES</option>
                                    <option value="false" {{ $data->up_btn == 'false' ? 'selected' : '' }}>NO</option>
                                </select>
                            </div>


                            <button type="submit" class="btn bg-gradient-info mt-3">Save Changes</button>
                        </form>

                    </div>

                    <!--api setting Start------------->
                    <div class="tab-pane fade " id="v-pills-api" role="tabpanel" aria-labelledby="api-section-tab">
                        <figure>
                            <blockquote class="blockquote">
                                <h5>
                                    <p class="ps-2"><b>API Setting</b></p>
                                </h5>
                            </blockquote>
                            <figcaption class="blockquote-footer ps-1">
                                Manage API Content Limit & Pagination Limit
                            </figcaption>
                        </figure>

                        <form method="post" action="/setting/update">
                            @csrf
                            <input type="hidden" name="type" value="api">
                            <hr class="horizontal dark my-2">


                            <hr class="horizontal dark my-2">
                            <div class-="row">
                                <div class="col-6">
                                    <label for="categoryName" class="form-label">Story Order By</label>
                                    <select class="form-control" name="STORY_ORDER" id="choices-tag1"
                                        placeholder="Select Mode" required>
                                        <option value="" selected="">Select Story Order By</option>
                                        <option value="item_order" {{ env('STORY_ORDER') == 'item_order' ? 'selected' : '' }}>
                                            Item Order
                                        </option>
                                        <option value="title" {{ env('STORY_ORDER') == 'title' ? 'selected' : '' }}>Name
                                        </option>
                                        <option value="id" {{ env('STORY_ORDER') == 'id' ? 'selected' : '' }}>ID
                                        </option>
                                    </select>
                                </div>
                                
                                 <div class="col-6">
                                    <label for="categoryName" class="form-label">Story Short By</label>
                                    <select class="form-control" name="STORY_SHORT" id="choices-tag1"
                                        placeholder="Select Mode" required>
                                        <option value="" selected="">Select Story Short By</option>
                                        <option value="ASC" {{ env('STORY_ORDER') == 'item_order' ? 'selected' : '' }}>
                                           Old Story First
                                        </option>
                                        <option value="DESC" {{ env('STORY_ORDER') == 'title' ? 'selected' : '' }}>Latest Story First
                                        </option>
                                    </select>
                                </div>
                                
                            </div>
                            

                            <hr class="horizontal dark my-2">
                            <div>
                                <label for="categoryName" class="form-label">Category Order By</label>
                                <select class="form-control" name="CAT_ORDER" id="choices-tag1"
                                    placeholder="Select Mode" required>
                                    <option value="" selected="">Select Category Order</option>
                                    <option value="item_order" {{ env('CAT_ORDER') == 'item_order' ? 'selected' : '' }}>
                                        Item Order
                                    </option>
                                    <option value="asc" {{ env('CAT_ORDER') == 'asc' ? 'selected' : '' }}>ASC</option>
                                    <option value="desc" {{ env('CAT_ORDER') == 'desc' ? 'selected' : '' }}>DESC
                                    </option>
                                </select>
                            </div>

                            <button type="submit" class="btn bg-gradient-info mt-3">Save</button>
                        </form>

                    </div>

                    <!--privay policy Start------------->
                    <div class="tab-pane fade " id="v-pills-privacy" role="tabpanel"
                        aria-labelledby="privacy-section-tab">
                        <figure>
                            <blockquote class="blockquote">
                                <h5>
                                    <p class="ps-2"><b>Privacy Policy</b></p>
                                </h5>
                            </blockquote>
                            <figcaption class="blockquote-footer ps-1">
                            </figcaption>
                        </figure>

                        <label for="projectName" class="form-label">Privacy Policy URL : <a href="{{env('APP_URL')}}privacy-policy" target="_blank">{{env('APP_URL')}}privacy-policy</a></label>
                        <form method="post" action="/setting/update">
                            @csrf
                            <input type="hidden" name="type" value="privacy">

                            <hr class="horizontal dark my-2">
                            <div class="col-sm-12 mt-3">
                                <label class="form-label">Privacy Policy</label>
                                <textarea class="ckeditor form-control" name="privacy_policy">{{ $data->privacy_policy }}</textarea>
                            </div>
                            <button type="submit" class="btn bg-gradient-info mt-3">Save</button>
                        </form>

                    </div>

                </div>

                <!-- Card Profile -->

                <!-- Card Basic Info -->
            </div>
        </div>
    </div>
@endsection
@include('modal')

@push('js')
    <script src="{{ URL::asset('assets/js/plugins/modal.js') }}"></script>
    <script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
    <script src="../../assets/js/plugins/sweetalert.min.js"></script>
    <script src="../../assets/js/plugins/action.js"></script>
    <script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>


    <script>
       
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);

            var url = document.location.toString();
            console.log('selected_t ' + url);

            if (url.match('#')) {
                var tag = url.split('#')[1];
                if (tag == '') {
                    activaTab('#v-pills-general');
                } else {
                    activaTab('#v-pills-' + tag);
                }

            } else {
                activaTab('#v-pills-general');
            }

        });

        function activaTab(tab) {
            $(tab).removeClass('tab-pane fade').addClass('tab-pane fade show active');
            disableAll(tab.replace('#v-pills-', ''));
        };

        $('#a-v-pills-general').click(function() {
            disableAll('general');
        });

        $('#a-v-pills-sharemsg').click(function() {
            disableAll('sharemsg');
        });

        $('#a-v-pills-onesignal').click(function() {
            disableAll('onesignal');
        });

        $('#a-v-pills-update').click(function() {
            disableAll('update');
        });

        $('#a-v-pills-api').click(function() {
            disableAll('api');
        });

        $('#a-v-pills-privacy').click(function() {
            disableAll('privacy');
        });

        if (document.getElementById('choices-tag')) {
            var tag = document.getElementById('choices-tag');
            const example = new Choices(tag);
        }


        function disableAll(type) {

            $('#a-v-pills-general').css({
                'background': 'white',
                'color': '#3d3f6f'
            });

            $('#a-v-pills-sharemsg').css({
                'background': 'white',
                'color': '#3d3f6f'
            });
            $('#a-v-pills-onesignal').css({
                'background': 'white',
                'color': '#3d3f6f'
            });
            $('#a-v-pills-update').css({
                'background': 'white',
                'color': '#3d3f6f'
            });

            $('#a-v-pills-api').css({
                'background': 'white',
                'color': '#3d3f6f'
            });
            $('#a-v-pills-privacy').css({
                'background': 'white',
                'color': '#3d3f6f'
            });

            (type == 'general') ? $('#a-v-pills-general').css({
                'background': 'green',
                'color': 'white'
            }): '';

            (type == 'sharemsg') ? $('#a-v-pills-sharemsg').css({
                'background': 'green',
                'color': 'white'
            }): '';
            (type == 'onesignal') ? $('#a-v-pills-onesignal').css({
                'background': 'green',
                'color': 'white'
            }): '';
            (type == 'update') ? $('#a-v-pills-update').css({
                'background': 'green',
                'color': 'white'
            }): '';
            (type == 'api') ? $('#a-v-pills-api').css({
                'background': 'green',
                'color': 'white'
            }): '';

            (type == 'privacy') ? $('#a-v-pills-privacy').css({
                'background': 'green',
                'color': 'white'
            }): '';

        }


    </script>
@endpush
