@extends('user_type.auth', ['parentFolder' => 'pages', 'childFolder' => ''])

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Language</h5>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
          <div class="ms-auto my-auto">
                <a href="#" class="btn bg-gradient-info btn-sm mb-0 addLang">+&nbsp; ADD NEW</a>
              </div>
              
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>#</th>
                <th>IMAGE</th>
                <th>TITLE</th>
                <th>LANGUAGE CODE</th>
                <th>ORDER BY</th>
                <th>STATUS</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              @if(count($data) > 0)
              @foreach($data as $item)
              <tr id="{{$item->id}}">
                <td class="text-sm">
                  <div class="form-check my-auto">
                   #
                  </div>
                </td>
                <td class="text-sm">
                    <span class="my-2 text-xs">
                            <img src="{{ url('/'.$item->image) }}" class="img border-radius-lg" alt="Responsive image" width="100"  height="100">
                    </span>
                </td>
                <td class="text-sm">{{$item->title}}</td>
                <td class="text-sm">{{$item->code}}</td>
                <td class="text-sm">{{$item->item_order}}</td>
                <td class="text-sm" >
                  @if($item->status==0)
                  <span class="badge bg-success">Active</span>
                  @else
                  <span class="badge bg-danger">Disabled</span>
                  @endif
                </td>
                <td class="text-sm">
                  <a href="#" class="mx-3 editLang" data-bs-toggle="tooltip" id="{{$item->id}}"  data-bs-original-title="Edit">
                    <i class="fas fa-edit text-success"></i>
                  </a>                  
                </td>
              </tr>
              @endforeach
              @else
              <tr>no content </tr>
              @endif
            </tbody>
          </table>
          
          {{$data->links('components.paginate')}}
        </div>
      </div>
    </div>
  </div>
</div>

{{-- Modal Add Start --}}

<div class="modal fade" id="catModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalMessageTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Add Language</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fa fa-close">×</i>
                </button>
            </div>
            <div class="modal-body">
                <form action="/language/store" method="POST" enctype="multipart/form-data">
                    @csrf

                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Language Title</label>
                        <input type="text" class="form-control" name="title" placeholder="English" required>
                    </div>

                    <div class="form-group">
                      <label for="recipient-name" class="form-label">Language Code</label>
                      <input type="text" class="form-control" name="code" placeholder="en" required>
                    </div>

                    <div class="form-group">
                      <label for="recipient-name" class="form-label">Language Image</label>
                      <input type="file" class="form-control" name="icon" required>
                    </div>

                    <div class="form-group">
                      <label for="recipient-name" class="form-label">Language Order By</label>
                      <input type="number" class="form-control" name="item_order"  value="1" placeholder=" 0 = show on first">
                  </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn bg-gradient-info">ADD</button>

                </form>
            </div>
        </div>
    </div>
</div>

{{-- Modal Add End --}}

{{-- Modal Update Start --}}

<div class="modal fade" id="catupdateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalMessageTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fa fa-close">×</i>
                </button>
            </div>
            <div class="modal-body">
                <form action="/language/update" method="POST" enctype="multipart/form-data">
                    @csrf

                    <input type="hidden" name="id" id="lang_id"/>
                    <input type="hidden" name="oldicon" id="oldicon"/>

                    <div class="form-group">
                      <label for="recipient-name" class="form-label">Language Title</label>
                      <input type="text" class="form-control" name="title" id="lang_title" placeholder="English" required>
                  </div>

                  <div class="form-group">
                    <label for="recipient-name" class="form-label">Language Code</label>
                    <input type="text" class="form-control" name="code" id="lang_code" placeholder="en" required>
                  </div>

                  <div class="form-group">
                    <label for="recipient-name" class="form-label">Language Image</label>
                    <input type="file" class="form-control" name="icon" required>
                  </div>

                  <div class="form-group">
                    <label for="recipient-name" class="form-label">Language Order By</label>
                    <input type="number" class="form-control" name="item_order" id="lang_order"  placeholder=" 0 = show on first">
                  </div>

                  <div class="form-group">
                    <label for="recipient-name" class="form-label">Language Status</label>
                  <select name="status" class="form-control">
                    <option value="0">Active</option>
                    <option value="1">Disabled</option>
                  </select>
                  </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn bg-gradient-info">Save Changes</button>

                </form>
            </div>
        </div>
    </div>
</div>

{{-- Modal Update End --}}
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found",
        info: "Showing {{ $data->firstItem() }} to {{$data->lastItem()}} of {{$data->total()}} entries"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });

  

    $("body").on("click", ".addLang", function () {
        $("#catModal").modal('show');
        
    });
    
    $("body").on("click", ".editLang", function () {
        var current_object = $(this);
        var link = window.location.origin;
        id=current_object.attr('id');
         $.ajax({
            url: '/language/edit/'+id,
            type: "GET",

            success: function (data) {
                 $("#catupdateModal").modal('show');
                 $("#id").val(data['id']);
                 $("#link").val(data['link']);
                 $("#oldicon").val(data['banner']);
                 $('#choices-tag option[value="'+ data['bannertype'] +'"]').attr("selected", "selected");
                 
                 
                console.log(data);
            },
          });

    });
  
          
    if (document.getElementById('choices-tag')) {
      var tag = document.getElementById('choices-tag');
      const example = new Choices(tag);
    }

</script>
@endpush