@extends('user_type.auth', ['parentFolder' => 'dashboards', 'childFolder' => 'none'])
@section('content')
  
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqvmap/1.5.1/jqvmap.min.css">

  <div class="row">
    <div class="col-lg-12 position-relative z-index-2">
      <div class="card card-plain mb-4">
        <div class="card-body p-3">
          <div class="row">
            <div class="col-lg-6">
              <div class="d-flex flex-column h-100">
                <h2 class="font-weight-bolder mb-0"></h2>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
          <div class="col-lg-3 col-sm-5">
            <div class="card  mb-4">
              <a href="#">
              <div class="card-body p-3">
                <div class="row">
                  <div class="col-8">
                    <div class="numbers">
                      <p class="text-sm mb-0 text-capitalize font-weight-bold">Today App Open</p>
                      <h5 class="font-weight-bolder mb-0">
                       {{number_format($today)}}
                        <span class="text-success text-sm font-weight-bolder"></span>
                      </h5>
                    </div>
                  </div>
                  <div class="col-4 text-end">
                    <div class="icon icon-shape bg-gradient-info shadow text-center border-radius-md">
                      <i class="fas fa-user"></i>
                    </div>
                  </div>
                </div>
              </div>
              </a>
            </div>
   
            </a>
          </div>
          <div class="col-lg-3 col-sm-5 mt-sm-0 mt-4">
            <div class="card  mb-4">
              <a href="/category">
              <div class="card-body p-3">
                <div class="row">
                  <div class="col-8">
                    <div class="numbers">
                      <p class="text-sm mb-0 text-capitalize font-weight-bold">Category</p>
                      <h5 class="font-weight-bolder mb-0">
                        {{number_format($category)}}
                        <span class="text-danger text-sm font-weight-bolder"></span>
                      </h5>
                    </div>
                  </div>
                  <div class="col-4 text-end">
                    <div class="icon icon-shape bg-gradient-success shadow text-center border-radius-md">
                      <i class="fas fa-folder"></i>
                    </div>
                  </div>
                </div>
              </div>
              </a>
            </div>
           
          </div>
          <div class="col-lg-3 col-sm-5 mt-sm-0 mt-4">
            <div class="card  mb-4">
              <a href="/story">
              <div class="card-body p-3">
                <div class="row">
                  <div class="col-8">
                    <div class="numbers">
                      <p class="text-sm mb-0 text-capitalize font-weight-bold">Story</p>
                      <h5 class="font-weight-bolder mb-0">
                         {{number_format($story)}}
                        <span class="text-danger text-sm font-weight-bolder"></span>
                      </h5>
                    </div>
                  </div>
                  <div class="col-4 text-end">
                    <div class="icon icon-shape bg-gradient-warning shadow text-center border-radius-md">
                      <i class="fas fa-file"></i>
                    </div>
                  </div>
                </div>
              </div>
              </a>
            </div>

          </div>
          <div class="col-lg-3 col-sm-5 mt-sm-0 mt-4">
            {{-- <div class="card  mb-4">
              <a href="/language">
              <div class="card-body p-3">
                <div class="row">
                  <div class="col-8">
                    <div class="numbers">
                      <p class="text-sm mb-0 text-capitalize font-weight-bold">Language</p>
                      <h5 class="font-weight-bolder mb-0">
                         {{number_format($lang)}}
                        <span class="text-danger text-sm font-weight-bolder"></span>
                      </h5>
                    </div>
                  </div>
                  <div class="col-4 text-end">
                    <div class="icon icon-shape bg-gradient-dark shadow text-center border-radius-md">
                      <i class="fas fa-globe"></i>
                    </div>
                  </div>
                </div>
              </div>
              </a>
            </div>
           --}}
          </div>
    </div>
  

  

    <div class="row mt-3">

    <div class="col-sm-6">
          <div class="card">
            <div class="card-header pb-0 p-3">
              <div class="d-flex align-items-center">
                <h6 class="mb-0">Visitor Analytics {{ date('Y')}}</h6>
                <button type="button" class="btn btn-icon-only btn-rounded btn-outline-secondary mb-0 ms-2 btn-sm d-flex align-items-center justify-content-center ms-auto" data-bs-toggle="tooltip" data-bs-placement="bottom" title="User Analytics">
                  <i class="fas fa-info"></i>
                </button>
              </div>
            </div>
            <div class="card-body p-3">
               <div class="card-block text-center">
                    <div id="revenueMonthly" class="chart-shadow"></div>
                </div>
            </div>
          </div>
    </div>
    </div>
 
<div class="row mt-3">
  <h5 class="mb-0">Top 4 Story</h5>
    <div class="row mb-5">
        @foreach ($topstory as $item)
        <div class="col-sm-3  mt-1">
          <div class="card">
            <img class="card-img-top" src="{{url('/'.$item->image)}}" height="250">
            <div class="position-relative" style="height: 50px;overflow: hidden;margin-top: -50px;z-index:2;position: relative;">
              <div class="position-absolute w-100 top-0" style="z-index: 1;">
                  <svg class="waves waves-sm" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 24 150 40" preserveAspectRatio="none" shape-rendering="auto">
                    <defs>
                      <path id="card-wave" d="M-160 44c30 0 58-18 88-18s 58 18 88 18 58-18 88-18 58 18 88 18 v44h-352z"></path>
                    </defs>
                    <g class="moving-waves">
                      <use xlink:href="#card-wave" x="48" y="-1" fill="rgba(255,255,255,0.30"></use>
                      <use xlink:href="#card-wave" x="48" y="3" fill="rgba(255,255,255,0.35)"></use>
                      <use xlink:href="#card-wave" x="48" y="5" fill="rgba(255,255,255,0.25)"></use>
                      <use xlink:href="#card-wave" x="48" y="8" fill="rgba(255,255,255,0.20)"></use>
                      <use xlink:href="#card-wave" x="48" y="13" fill="rgba(255,255,255,0.15)"></use>
                      <use xlink:href="#card-wave" x="48" y="16" fill="rgba(255,255,255,0.99)"></use>
                    </g>
                  </svg>
                </div>
            </div>
            <div class="card-body">
              <h5>
                {{$item->title}}
              </h5>
              <p>
                <span class="badge badge-dark text-white">Category: {{$item->catName}}</span>
                <span class="badge badge-info text-black">Views:{{$item->views}}</span>
              </p>
              {{-- <a href="javascript:;" class="text-primary icon-move-right">More about us
                <i class="fas fa-arrow-right text-xs ms-1" aria-hidden="true"></i>
              </a> --}}
            </div>
          </div>

        </div>
        @endforeach
    </div>
    </div>



  </div>
  </div>
@endsection

@push('js')  
  <script src="{{ URL::asset('assets/js/plugins/chartjs.min.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/threejs.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/orbit-controls.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/dash.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/apexcharts.min.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/vmap/jquery.vmap.min.js') }}"></script>
  <script src="{{ URL::asset('assets/js/plugins/vmap/jquery.vmap.world.js') }}"></script>
  
  <script>

      $('#dynamic_select').on('change', function () {
          var url = $(this).val(); // get selected value
          if (url) { // require a URL
              window.location = url; // redirect
          }
          return false;
      });
      
        
    $(document).ready(function() {

        var user = @json($alluser);
        var total = {{$user}};
        users_Analysis(total,user[1]['count'],user[2]['count'],user[3]['count'],user[4]['count'],user[5]['count'],user[6]['count'],user[7]['count'],user[8]['count'],user[9]['count'],user[10]['count'],user[11]['count'],user[12]['count']);
        
    });
</script>

@endpush