@extends('user_type.auth', ['parentFolder' => 'pages', 'childFolder' => ''])

@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <div class="row">
        <div class="col-12">
            <div class="card">
                <!-- Card header -->
                <div class="card-header pb-0">
                    <div class="d-lg-flex">
                        <div>
                            <h5 class="mb-0">App AdNetwork List</h5>
                        </div>
                        <div class="ms-auto my-auto mt-lg-0 mt-4">
                            <div class="ms-auto my-auto">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body px-0 pb-0">
                    <div class="table-responsive">
                        @if ($errors->get('msgError'))
                            <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                                <span class="alert-text text-white">
                                    {{ $errors->first() }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                        @endif
                        @if (session('success'))
                            <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success"
                                role="alert">
                                <span class="alert-text text-white">
                                    {{ session('success') }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach ($ad as $item )
                <div class="col-sm-4  mt-3">
                    <div class="card">
                        <img class="avatar-xxxl ps-3 pt-3"
                            src="{{url('/'.$item->image)}}" height="100" width="180">
                        <div class="card-body pb-0">
                            <h5>
                                {{$item->title}}
                            </h5>
                            <div class="row">
                                <div class="col-9">
                                    <a href="/ads/adnetwork/edit/{{$item->id}}" class="btn bg-gradient-success" >
                                        <i class="fas fa-edit text-white"> Edit</i>
                                    </a>
                                </div>
                                <div class="col">
                                    <form action="/ads/adnetwork/action" method="POST">
                                        @csrf
                                        <input type="hidden" name="id" value="{{$item->id}}">
                                        <div class="form-check form-switch ">
                                            <input class="form-check-input adsbtn" name="status" type="checkbox" onchange="this.form.submit()"  id="flexSwitchCheckDefault"
                                            {{($item->status == '1') ? 'checked' : ''}}>
                                            <label class="form-check-label" for="flexSwitchCheckDefault"></label>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>   
                @endforeach
                
            </div>
        </div>
    </div>
    </div>

    @include('modal')
@endsection
@push('js')
    <script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
    <script src="../../assets/js/plugins/sweetalert.min.js"></script>
    <script src="../../assets/js/plugins/action.js"></script>
    <script></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);
        });
 

    </script>
@endpush
