@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')
    <main class="main-content mt-1 border-radius-lg">
        <div class="container my-3 py-3 d-flex flex-column">
            @if ($errors->get('msgError'))
                <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                    <span class="alert-text text-white">
                        {{ $errors->first() }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif
            @if (session('success'))
                <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                    <span class="alert-text text-white">
                        {{ session('success') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                </div>
            @endif

            <div class="row mb-5 justify-content-center align-items-center">
                <div class="col-lg-9 col-12 mx-auto">
                    <!-- Card Profile -->
                    <div class="row">
                        <div class="col-4"></div>
                        <div class="col-4">
                            <div class="card card-body text-center">
                                <div class="row col-lg-12">
                                    <div class="col-sm-12">
                                        <div class="">
                                            <div>
                                                <span class=" ">
                                                    <img src="{{ url('/' . $data->image) }}" class="" id="imgDisplay"
                                                        alt="Profile Photo" width="80%">
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <!-- <div class="h-100"> -->
                                        <p class="mb-0 font-weight-bold text-sm">
                                            {{ $data->title }}
                                        </p>
                                        <!-- </div> -->
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="col-4"></div>
                    </div>
                    <!-- Card Basic Info -->
                    <div class="card mt-4" id="basic-info">
                        <div class="card-header">
                            <h5>AdNetwork Configuration</h5>
                        </div>
                        <div class="card-body pt-0">
                            <form action="/ads/adnetwork/update" method="POST" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="id" value="{{ $data->id }}">

                                @if ($data->slug == 'admob' || $data->slug == 'unity' || $data->slug == 'wortise' || $data->slug == 'startio')
                                    <div class="col-sm-12">
                                        @if ($data->slug == 'admob')
                                            <label class="form-label mt-4">Admob Publisher ID</label>
                                        @elseif($data->slug == 'unity')
                                            <label class="form-label mt-4">Unity Game ID</label>
                                        @elseif($data->slug == 'wortise')
                                            <label class="form-label mt-4">Wortise App ID</label>
                                        @elseif($data->slug == 'startio')
                                            <label class="form-label mt-4">StartIo App ID</label>
                                        @endif
                                        <div class="input-group">
                                            <input class="form-control" type="text" name="app_id" value="{{$data->app_id}}"
                                                placeholder="xxx"
                                                {{ $data->slug == 'unity' || $data->slug == 'wortise' || $data->slug == 'startio' ? 'required' : '' }}>
                                        </div>
                                    </div>
                                @endif
                                <hr>
                                
                                @if ($data->slug == 'admob')
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-2">Open Ad Status</label>
                                    <select name="openad" id="choices-tag" class="form-control">
                                        <option value="true" {{($data->openad == 'true') ? 'selected' : ''}} >ON</option>
                                        <option value="false" {{($data->openad == 'false') ? 'selected' : ''}} >OFF</option>
                                    </select>
                                </div>

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Open Ad ID</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" name="openad_id" value="{{$data->openad_id}}"
                                            placeholder="xxx" >
                                    </div>
                                </div>
                                    
                                <hr> 
                                 @endif
  
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-2">Banner Ad Status</label>
                                    <select name="banner" id="choices-tag" class="form-control">
                                        <option value="true" {{($data->banner == 'true') ? 'selected' : ''}} >ON</option>
                                        <option value="false" {{($data->banner == 'false') ? 'selected' : ''}} >OFF</option>
                                    </select>
                                </div>

                                @if ($data->slug != 'startio' && $data->slug != 'custom')
                                    <div class="col-sm-12">
                                        <label class="form-label mt-4">Banner Ad ID</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="banner_id" value="{{$data->banner_id}}"
                                                placeholder="xxx" {{ $data->slug != 'startio' ? 'required' : '' }}>
                                        </div>
                                    </div>
                                @endif

                                <hr>

                                <div class="col-sm-12">
                                    <label class="form-label mt-2">Interstital Ad Status</label>
                                    <select name="interstital" id="choices-tag" class="form-control">
                                        <option value="true" {{($data->interstital == 'false') ? 'selected' : ''}}>ON</option>
                                        <option value="false" {{($data->interstital == 'false') ? 'selected' : ''}}>OFF</option>
                                    </select>
                                </div>

                                @if ($data->slug != 'startio' && $data->slug != 'custom')
                                    <div class="col-sm-12">
                                        <label class="form-label mt-4">Interstital Ad ID</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="interstital_id" value="{{$data->interstital_id}}"
                                                placeholder="xxx" {{ $data->slug != 'startio' ? 'required' : '' }}>
                                        </div>
                                    </div>
                                @endif

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Interstital Ad AdClick</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="interstital_click" value="{{$data->interstital_click}}"
                                            placeholder="xxx" required>
                                    </div>
                                </div>
                                <hr>
                                @if ($data->slug != 'unity' && $data->slug != 'wortise'  && $data->slug != 'custom' )  

                                <div class="col-sm-12">
                                    <label class="form-label mt-2">Native Ad Status</label>
                                    <select name="native" id="choices-tag" class="form-control">
                                        <option value="true" {{($data->native == 'false') ? 'selected' : ''}}>ON</option>
                                        <option value="false" {{($data->native == 'false') ? 'selected' : ''}}>OFF</option>
                                    </select>
                                </div>

                                @if ($data->slug != 'startio')
                                    <div class="col-sm-12">
                                        <label class="form-label mt-4">Native Ad ID</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" name="native_id"
                                                value="{{$data->native_id}}" placeholder="xxx"
                                                {{ $data->slug != 'startio' ? 'required' : '' }}>
                                        </div>
                                    </div>
                                @endif

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Native Ad Position</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="native_posi"
                                            value="{{$data->native_posi}}" placeholder="xxx" required>
                                    </div>
                                </div>
                                <hr>
                                @endif

                                <div class="col-sm-12">
                                  <label class="form-label mt-2">{{ $data->title }} Status</label>
                                  <select name="status" id="choices-tag" class="form-control">
                                      <option value="1" {{($data->status == '1') ? 'selected' : ''}}>Active</option>
                                      <option value="0" {{($data->status == '0') ? 'selected' : ''}}>Inactive</option>
                                  </select>
                              </div>

                                <div class="">
                                    <button type="submit" class="btn bg-gradient-info btn-sm float-end mt-6 mb-0">Save
                                        changes</button>
                                </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </main>
@endsection
@push('js')
    <script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
    <script>
        // $("#file-input").change(function(){
        //     readURL(this);
        // });
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            $("#alert-success").delay(3000).slideUp(300);

        });

        if (document.getElementById('choices-tag')) {
            var tag = document.getElementById('choices-tag');
            const example = new Choices(tag);
        }
    </script>
@endpush
