@extends('user_type.auth', ['parentFolder' => 'video', 'childFolder' => ''])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        
        <div class="card card-body mt-4">
            <h6 class="mb-0">Add AdNetwork </h6>
            <p class="text-sm mb-0">Fill Data</p>
            <form action="/ads/adnetwork/store" method="POST"  enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="type" value="adnetwork"/>
             
            <hr class="horizontal dark my-3">
            <label for="projectName" class="form-label">AdNetwork Title</label>
            <input type="text" class="form-control" name="title" value="{{old('title')}}" placeholder="Ads Video" required>
            
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">AdNetwork Icon</label>
            <input type="file" class="form-control" name="icon" placeholder="" required>
            @error('icon')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror
 
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">AdNetwork slug </label>
            <input type="text" class="form-control" name="slug" value="{{old('slug')}}" placeholder="admob">
            @error('btn_name')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror
            
            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Ads Description Max 2-3 Line</label>
            <textarea class="form-control" name="ads_info" value="{{old('ads_info')}}"></textarea>
            @error('description')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror

            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/ads/adnetwork') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Add AdNetwork</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script>
    if (document.getElementById('choices-tag')) {
      var tag = document.getElementById('choices-tag');
      const example = new Choices(tag);
    }
</script>
@endpush