<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Category;
use App\Models\Lang;
use App\Models\Story;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Fun;
use App\Models\HashTag;
use App\Models\Slider;
use Carbon\Carbon;
use Validator;

class StoryController extends Controller
{
   
     function index(){

        if(isset(request()->cat) && request()->cat!='all' ){
            $where=['story.cat'=>request()->cat];

            $story = DB::table('story')
            ->join('category','category.id','=','story.cat')
            ->where($where)
            ->select('story.*','category.title as catName')
            ->orderBy('id','DESC')->paginate();
        }
        else{
            $story = DB::table('story')
            ->join('category','category.id','=','story.cat')
            ->select('story.*','category.title as catName')
            ->orderBy('id','DESC')->paginate();
        }
        

        $cat=Category::all();
        $data=[
            'data'=>$story,
            'cat'=>$cat
        ];
        return view('story.index',$data);
     } 
     
  
     function create(){
        $data=[ 'cat'=>Category::all()];
        return view('story.add',$data);
     }

     function store(Request $req){
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/story/", null, null, $req, "icon", false);
            if ($filename == null) {
                return redirect('/story')->with('error', 'Technical Error in Image Upload');
            }

            $filename='images/story/'.$filename;
        } else {
            return redirect('/story')->with('error', 'Please Select Valid Image!');
        }
        
        $videourl=null;
        
        if($req->type==1){
            if($req->video_url==null){
                return redirect('/story')->with('error', 'Please Add Valid Youtube video url');
            }
            
            preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $req->video_url, $match);
            
            if($match){
                $videourl=$match[1];
            }else{
                return redirect('/story')->with('error', 'Please Add Valid Youtube video url');
            }
        }
                    
                    

        $story=new Story;
        $story->title=$req->title;
        $story->cat=$req->cat;
        $story->type=$req->type;
        if($req->type==1){ $story->video_url=$videourl; }
        $story->image=$filename;
        $story->description=$req->description;
        $story->item_order=$req->item_order;
        $story->featured=(isset($req->featured)) ? ($req->featured == 'on') ? 1 : 0  : 0 ;
        $story->publish_date=$req->publish_date;
        $story->save();
        
        if(isset($req->slider) && $req->slider == 'on'){
           Slider::insert(['post_id'=>$story->id,'title'=>$req->title,'image'=>$filename,'type'=>'post','cat'=>$req->cat]); 
        }
        

        return redirect('/story')->with('success', 'Added Successfully!');
     }

     function edit(Story $id){
        $data=[
            'story'=>$id,
            'cat'=>Category::all()
      ];
        return view('story.edit',$data);
     }

     function update(Request $req){

        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/story/", null, null, $req, $req->oldicon, true);
            if ($filename == null) {
                return redirect('/story')->with('error', 'Technical Error in Image Upload');
            }
            $filename='images/story/'.$filename;
        } else {
            $filename=$req->oldicon; 
        }
        
        if($req->type==1){
            if($req->video_url==null){
                return redirect('/story')->with('error', 'Please Add Valid Youtube video url');
            }
            
            preg_match('%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i', $req->video_url, $match);
            
            if($match){
                $videourl=$match[1];
            }else{
                return redirect('/story')->with('error', 'Please Add Valid Youtube video url');
            }
        }

        $story=Story::find($req->id);
        $story->title=$req->title;
        $story->type=$req->type;
        if($req->type==1){ $story->video_url=$videourl; }
        $story->cat=$req->cat;
        $story->image=$filename;
        $story->description=$req->description;
        $story->item_order=$req->item_order;
        $story->publish_date=$req->publish_date;
        $story->save();
        
        if(isset($req->slider) && $req->slider != 'on'){
           Slider::where(['post_id'=>$story->id,'type'=>'post'])->delete(); 
        }

        return redirect('/story')->with('success', 'Update Successfully!');

     }


     function destroy($id){
        if(auth()->user()->role_delete=='false'){
            return env('PERMISSION_ERROR');
        }
        
         $story=Story::find($req->id);
        Fun::removeImage($story->image);
       $story->delete();
        return 1;
     }

     function action(Request $req){

         if ($req->status == "enable") {
            if(auth()->user()->role_edit=='false'){
                return env('PERMISSION_ERROR');
            }
                        
            $update = Novel::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            if(auth()->user()->role_edit=='false'){
                return env('PERMISSION_ERROR');
            }
            $update = Novel::whereIn('id', explode(",", $req->id))->update(['status' => 2]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
     }
}
