<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\_Onboarding;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use File, Image;
use App\Http\Controllers\Fun;

class SettingController extends Controller
{


    public function index()
    {
        $data = DB::table('setting')->where('id', 1)->first();
        return view('pages/setting', compact('data'));
    }

    function update(Request $req){

        switch($req->type){
            
            case 'general':
                if ($req->icon) {
                    $filename =  Fun::StoreImage("images/", 200, 200, $req, null, false);
                    if ($filename == null) {
                        return redirect('/setting#'.$req->type)->with('error', 'Technical Error in Image Upload');
                    }
                    $filename='images/'.$filename;

                    DB::table('setting')->where('id',1)->update(['app_name'=>$req->app_name,'email'=>$req->email,'website'=>$req->website,'logo'=>$filename,'author'=>$req->author,'description'=>$req->description]);
                }else{
                    DB::table('setting')->where('id',1)->update(['app_name'=>$req->app_name,'email'=>$req->email,'website'=>$req->website,'author'=>$req->author,'description'=>$req->description]);
                }

                return redirect('/setting#'.$req->type)->with('success','Update Successfully');

                break;

            case 'sharemsg':
            
                DB::table('setting')->where('id',1)->update(['sharemsg'=>$req->sharemsg]);
            
                return redirect('/setting#'.$req->type)->with('success','Update Successfully');

            break;    

            case 'onesignal':
                $this->updateData('ONESIGNAL_APP_ID',$req->onesignal_appid);
                $this->updateData('ONESIGNAL_REST_API_KEY',$req->onesignal_apikey);
                \Artisan::call('config:clear');
                return redirect('/setting#'.$req->type)->with('success','Update Successfully');
            break;    

            case 'update':
                
                DB::table('setting')->where('id',1)->update([
                    'up_version'=>$req->up_version,
                    'up_mode'=>$req->up_mode,
                    'up_msg'=>$req->up_msg,
                    'up_link'=>$req->up_link,
                    'up_btn'=>$req->up_btn,
                    'up_status'=>$req->up_status,
                ]);
                return redirect('/setting#'.$req->type)->with('success','Update Successfully');
            break; 

            case 'api':
                $this->updateData('STORY_ORDER',$req->STORY_ORDER);
                $this->updateData('CAT_ORDER',$req->CAT_ORDER);

                return redirect('/setting#'.$req->type)->with('success','Update Successfully');
            break; 
            
            case 'privacy':
                
                DB::table('setting')->where('id',1)->update([
                    'privacy_policy'=>$req->privacy_policy
                ]);
                return redirect('/setting#'.$req->type)->with('success','Update Successfully');
            break; 
        }


    }
   


    public static function updateData($key, $value)
    {
       
        $path = base_path('.env');

        if (file_exists($path)) {

            file_put_contents($path, str_replace(
                $key . '=' . env($key), $key . '=' . $value, file_get_contents($path)
            ));
        }
    }


}
