<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Category;
use App\Models\Lang;
use App\Http\Controllers\Fun;
use Carbon\Carbon;
use Validator;

class LangController extends Controller
{
   
    function index(){
        $data=Lang::orderBy('item_order', 'ASC')->fastPaginate();
        return view('pages.lang',compact('data'));
    } 
     
     function store(Request $req){
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/lang/", null, null, $req, "icon", false);
            if ($filename == null) {
                return redirect('/language')->with('error', 'Technical Error in Image Upload');
            }

            $filename='images/lang/'.$filename;
        } else {
            return redirect('/language')->with('error', 'Please Select Valid Image!');
        }

        Lang::insert([
            'title'=>$req->title,
            'image'=>$filename,
            'code'=>$req->code,
            'item_order'=>$req->item_order
        ]);

        return redirect('/language')->with('success', 'Added Successfully!');
     }

     function edit(Lang $id){
        return $id;
     }

     function update(Request $req){

        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/lang/", null, null, $req, $req->oldicon, true);
            if ($filename == null) {
                return redirect('/language')->with('error', 'Technical Error in Image Upload');
            }
            $filename='images/lang/'.$filename;
        } else {
            $filename=$req->oldicon; 
        }

        Lang::where('id',$req->id)->update([
            'title'=>$req->title,
            'image'=>$filename,
            'code'=>$req->code,
            'item_order'=>$req->item_order
        ]);

        return redirect('/language')->with('success', 'Update Successfully!');

     }


     function destroy($id){
        if(auth()->user()->role_delete=='false'){
            return env('PERMISSION_ERROR');
        }
        return 1;
     }

}
