<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\Story;
use App\Models\Category;
use App\Models\Lang;
use App\Models\Analytics;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class Home extends Controller
{
    public function index()
    {
        
        $allusercount = Analytics::select('date')
        ->get()
        ->groupBy(function ($datess) {
            if(Carbon::parse($datess->created_at)->format('Y')==Carbon::now()->year){
                            return Carbon::parse($datess->created_at)->format('m');
            }
        });

        $usermcountss = [];
        $userArrss = [];
    
        foreach ($allusercount as $key => $value) {
            $usermcountss[(int)$key] = count($value);
        }
    
        $monthss = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    
        for ($i = 1; $i <= 12; $i++) {
            if (!empty($usermcountss[$i])) {
                $userArrss[$i]['count'] = $usermcountss[$i];
            } else {
                $userArrss[$i]['count'] = 0;
            }
            $userArrss[$i]['month'] = $monthss[$i - 1];
        }       
    
    $today=Analytics::where('date',date('Y-m-d'))->count();
    
    $topstory= DB::table('story')
    ->join('category','category.id','=','story.cat')
    ->select('story.*','category.title as catName')
    ->orderBy('views','DESC')->limit(4)->get();
                
           return view('dashboards.default',
                [
                    'alluser'=>$userArrss,
                    'story'=>Story::count(),
                    'category'=>Category::count(),
                    'user'=>Analytics::count(),
                    'today'=>$today,
                    'topstory'=>$topstory,
                ]);
    }
    
   
    
    
}