<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Category;
use App\Models\Lang;
use App\Models\Story;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Fun;
use Carbon\Carbon;

class CategoryController extends Controller
{

    function index()
    {
       
        $data=Category::fastPaginate();
        return view('category.cat', ['data'=>$data]);
    }

    function getCat($id){
        return Category::where('lang',$id)->get();
    }
    function store(Request $req)
    {
        if (auth()->user()->role_create == 'false') {
            return redirect()->back()->withErrors(['msgError' => env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/cat/", null, null, $req, "icon", false);
            if ($filename == null) {
                return redirect('/category')->with('error', 'Technical Error in Image Upload');
            }

            $filename='images/cat/'.$filename;
        } else {
            return redirect('/category')->with('error', 'Please Select Valid Image!');
        }

        $cat = new Category;
        $cat->title = $req->title;
        $cat->image =$filename;
        $cat->item_order = $req->item_order;
        $cat->save();

        return redirect('/category')->with('success', 'Added Successfully!');
    }

    function edit(Category $id)
    {
        return $id;
    }

    function update(Request $req)
    {

        if (auth()->user()->role_create == 'false') {
            return redirect()->back()->withErrors(['msgError' => env('PERMISSION_ERROR')]);
        }

        if ($req->icon) {
            $filename =  Fun::StoreImage("images/cat/", null, null, $req, $req->oldicon, true);
            if ($filename == null) {
                return redirect('/category')->with('error', 'Technical Error in Image Upload');
            }

            $filename='images/cat/'.$filename;
        } else {
            $filename=$req->oldicon; 
        }

        $cat = Category::find($req->id);
        $cat->title = $req->title;
        $cat->image =$filename;
        $cat->item_order = $req->item_order;
        $cat->save();
        return redirect('/category')->with('success', 'Added Successfully!');
    }


    function destroy($id)
    {
        if (auth()->user()->role_delete == 'false') {
            return env('PERMISSION_ERROR');
        }

        $cat=Category::find($id);   
        Fun::removeImage($cat->image);

        $storyID=Story::where('cat',$id)->pluck('image')->get();

        for($i=0; $i<count($storyID); $i++){
            Fun::removeImage($storyID[$i]);
        }
        Story::where('cat',$id)->delete();
        $cat->delete();
        return 1;
    }

    function action(Request $req)
    {

        if ($req->status == "enable") {
            if (auth()->user()->role_edit == 'false') {
                return env('PERMISSION_ERROR');
            }

            $update = Category::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            if (auth()->user()->role_edit == 'false') {
                return env('PERMISSION_ERROR');
            }
            $update = Category::whereIn('id', explode(",", $req->id))->update(['status' => 2]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
}
