<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\Slider;
use App\Models\Story;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Image;
use File;
use Carbon\Carbon;

class BannerController extends Controller
{

    public function index()
    {
        $data = Slider::orderBy('id', 'DESC')->paginate();
        return view('slider/index', ['data' => $data]);
    }

    public function store(Request $request)
    {
        if (auth()->user()->role_create == 'false') {
            return env('PERMISSION_ERROR');
        }

        if ($request->icon && $request->type == 'banner') {
            $image = $request->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());

            $save = $image_resize->save('images/' . $fileNameToStore);
        }

        $banner = new Slider;

        if ($request->type == 'story') {
            $story = Story::where('id', $request->post_id)->first();
            $banner->post_id = $request->post_id;
            $banner->type = $request->type;
            $banner->image = $story->image;
            $banner->title = $story->title;
        } else {
            $banner->type = $request->type;
            $banner->link = $request->link;
            $banner->image = 'images/' . $fileNameToStore;
            $banner->title = $request->title;
        }

        $res = $banner->save();
        if ($res) {
            return redirect('/banner')->with('success', 'Added Successfully!');
        } else {
            return redirect('/banner')->with('error', 'Technical Error!');
        }
    }

    public function create()
    {
        $story = Story::all();
        return view('slider.add', ['story' => $story]);
    }

    public function edit(Slider $id)
    {
        $story = Story::all();
        return view('slider.edit', ['data' => $id, 'story' => $story]);
    }

    public function update(Request $request)
    {
        if (auth()->user()->role_edit == 'false') {
            return env('PERMISSION_ERROR');
        }

        if ($request->icon  && $request->type=='banner') {
            $image = $request->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            $save = $image_resize->save('images/' . $fileNameToStore);

            $icon = 'images/' . $fileNameToStore;
        } else {
            $icon = $request->oldicon;
        }

        if ($icon) {
            $banner = Slider::find($request->id);
            
        if ($request->type == 'story') {
            $story = Story::where('id', $request->post_id)->first();
            $banner->post_id = $request->post_id;
            $banner->type = $request->type;
            $banner->image = $story->image;
            $banner->title = $story->title;
        } else {
            $banner->type = $request->type;
            $banner->link = $request->link;
            $banner->image = 'images/' . $fileNameToStore;
            $banner->title = $request->title;
        }

            $res = $banner->save();
            if ($res) {
                return redirect('/banner')->with('success', 'Update Successfully!');
            } else {
                return redirect('/banner')->with('error', 'Technical Error!');
            }
        } else {
            return redirect('/banner')->with('error', 'Imagem not uploaded!');
        }
    }

    public function destroy($id)
    {
        if (auth()->user()->role_delete == 'false') {
            return env('PERMISSION_ERROR');
        }

        Slider::find($id)->delete();
        return 1;
    }

    public function action(Request $req)
    {
        if (auth()->user()->role_edit == 'false') {
            return DB::table('alias')->where('tag', 'permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = Slider::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = Slider::whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }
}
