<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Api\MyAuth;
use App\Http\Controllers\Controller;
use App\Models\Slider;
use App\Models\Ads;
use App\Models\Story;
use App\Models\StoryReport;
use App\Models\Category;
use App\Models\Language;
use App\Models\Analytics;
use Carbon\Carbon;
use DB,GeoIP;
use Illuminate\Http\Request;
use Image;
use Illuminate\Support\Facades\Cookie;

class Fun extends Controller
{
    
    function config(){
        
        $ads=Ads::where('status',1)->orderBy('id','DESC')->limit(1)->get();
        $config=DB::table('setting')->where('id',1)->get();
        
        return Response(['ads'=>$ads,'data'=>$config,'status'=>1]);
    }
    
    function configv2(){
        
        $ads=Ads::where('status',1)->orderBy('id','DESC')->limit(1)->get();
        $config=DB::table('setting')->where('id',1)->select('up_version','up_mode','up_msg','up_link','up_btn','up_status','sharemsg')->get();
        
        return Response(['ads'=>$ads,'data'=>$config,'status'=>1]);
    } 
    
    function about_us(){
        
        $config=DB::table('setting')->where('id',1)->select('email','app_name','website','author','description')->get();
        
        return Response(['data'=>$config,'status'=>1]);
    }
    
    function app_open_record(){
        $ip=$this->getIp();
        
        if(DB::table('user_analytics')->where(['ip'=>$ip,'date'=>date('Y-m-d')])->count()==0){
            DB::table('user_analytics')->insert(['ip'=>$ip,'date'=>date('Y-m-d')]);
            
            return response(['status'=>1]);
        }
        
        return response(['status'=>0]);
    }

    public function quick_read($type,$page)
    {
        $select=['story.id','story.title','story.image','story.type','story.video_url','story.description'];
        $limit = 12;
		$offset = $limit * $page;
		$data=Story::select($select)->inRandomOrder()->limit($limit)->offset($offset)->get();
        
        return response($data);
    }
    
    function search_story(Request $req){
        $select=['story.id','story.title','story.image','story.type','story.video_url','story.description'];
        
        $query=trim($req->data);
        $limit = 12;
		$offset = $limit * $req->page;
		
		$data=Story::whereRaw('LOWER(`title`) like ?','%'.strtolower($query).'%')->select($select)->orderBy('id','DESC')->limit($limit)->offset($offset)->get();
        
        return response($data);
    }
    
    public function story_feed($type,$page)
    {
        $select=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.publish_date','cat','category.title as catName'];
        $select1=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.description','story.publish_date'];
        $limit = 12;
		$offset = $limit * $page;
		
        switch($type){

            case 'latest': 
                $data=Story::select($select)->join('category','category.id', '=', 'story.cat')->orderBy('id','DESC')->limit($limit)->offset($offset)->get();
            break;
            
            case 'weekly':
                $start_date = date('Y-m-d', strtotime('today - 7 days'));
                $end_date = date('Y-m-d');
                $report=StoryReport::select('story_id')->whereBetween('date', array(strtotime($start_date), strtotime($end_date)))->take($limit)->get();

                $data=Story::whereIn('id',$report)->select($select)->join('category','category.id', '=', 'story.cat')->limit($limit)->offset($offset)->get();

            break;

            case 'featured':
                $data=Story::where('featured',1)->select($select)->join('category','category.id', '=', 'story.cat')->orderBy('id','DESC')->limit($limit)->offset($offset)->get();
            break;
            
            case 'trending':
                $data=Story::select($select1)->orderBy('views','DESC')->limit($limit)->offset($offset)->get();
            break;

        };
        
        return response($data);
    }
    
    
    public function home_feed($type,$limit)
    {
        $select=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.publish_date','cat','category.title as catName'];
        $select1=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.description','story.publish_date'];
        switch($type){

            case 'latest':
                $data=Story::select($select)->join('category','category.id', '=', 'story.cat')->orderBy('id','DESC')->limit($limit)->get();
            break;
            
            case 'weekly':
                $start_date = date('Y-m-d', strtotime('today - 7 days'));
                $end_date = date('Y-m-d');
                $report=StoryReport::select('story_id')->whereBetween('date', array(strtotime($start_date), strtotime($end_date)))->take($limit)->get();

                $data=Story::whereIn('id',$report)->select($select)->join('category','category.id', '=', 'story.cat')->limit($limit)->get();

            break;

            case 'featured':
                $data=Story::where('featured',1)->select($select)->join('category','category.id', '=', 'story.cat')->orderBy('id','DESC')->limit($limit)->get();
            break;
            
            case 'trending':
                $data=Story::select($select1)->join('category','category.id', '=', 'story.cat')->orderBy('views','DESC')->limit($limit)->get();
            break;

        };
        
        return response($data);
    }
    
    function slider(){
        return response(Slider::where('status',0)->orderBy('id','DESC')->get());
    }
    
    function category(){
        $cat=Category::where('status',0)->select('id','title','image')->orderBy(env('CAT_ORDER'),env('CAT_SHORT'))->get();
        $data=[];
        $i=0;
        foreach($cat as $item){
            $data[$i]['id']=$item->id;
            $data[$i]['title']=$item->title;
            $data[$i]['image']=$item->image;
            $data[$i]['count']=Story::where('cat',$item->id)->count();
            $i++;
        }
        return response($data);
    }
    
    function story_by_category($id,$page){
        $select=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.publish_date','cat','category.title as catName'];
        $limit = 12;
		$offset = $limit * $page;
        $data=Story::where(['story.status'=>0,'cat'=>$id])->select($select)->join('category','category.id', '=', 'story.cat')->limit($limit)->offset($offset)->orderBy(env('STORY_ORDER'),env('STORY_SHORT'))->get();
        return response($data);
    }
    
    function similar_story($id){
        $select=['story.id','story.title','story.image','story.views','story.type','story.video_url','story.publish_date','cat','category.title as catName'];
       return response(Story::where('cat',$id)->select($select)->join('category','category.id', '=', 'story.cat')->inRandomOrder()->take(5)->get()); 
    }
    
    function story_data($id){
        return response(Story::where('id',$id)->get());
    }
        
    function notification(){
        return response(DB::table('notification')->limit(30)->get());
    }
    
    public function getIp()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if (isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if (isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    function get_ip_location($ip)
    {
        try {
            $url = "http://ip-api.com/json/".$ip;

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            $response = curl_exec($ch);
            
             if (curl_errno($ch)) {
                return (['status'=>'false']);
             }
    
            curl_close($ch);

            // Retrieve IP data from API response
            $ipData = json_decode($response, true);

            // Return geolocation data
            return !empty($ipData)?$ipData:(['status'=>'false']);
        } 
        catch (\Exception $e) {
            return (['status'=>'false']);
        }
    } 


    public function customAd($type)
    {
        $data = DB::table('custom_ads')->where(['ad_type' => $type, 'status' => 0])->limit(1)->inRandomOrder()->get();
        return response($data);
    }
    
    
    public function customAdImpression($type, $id, $cl)
    {
        $this->adAction($type, $id, $cl);
        
        return response()->json(['msg' => "Imp Count",
        'code' => 201]);
    }

    public function adAction($adType, $id, $cl)
    {
        if ($adType == "custom") {
            $ads = Ads::find($id);
            if ($cl == "1") {
                $ads->click += +1;
            }else{
                $ads->impression += +1;
            }
            
            $ads->save();

        }
    }
    
    function story_impression($id,$device){
        $count=DB::table('story_report')->where(['device_id'=>$device,'story_id'=>$id])->count();
        
        if($count==0){
            $story=Story::find($id);
            $story->views+=+1;
            $story->save();
            DB::table('story_report')->insert(['device_id'=>$device,'story_id'=>$id,'date'=>date('Y-m-d')]);
            return response(['code'=>201,'msg'=>'201']);
        }else{
            return response(['code'=>401,'msg'=>'401']);
        }
    }

}
