<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\CustomAd;
use App\Models\Ads;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use File, Image;
use Illuminate\Support\Facades\Validator;

class AdsController extends Controller
{
    public function indexNative()
    {
        $data = CustomAd::where('ad_type', 'native')->paginate(20);
        return view('ads/native-ad', compact('data'));
    }

    public function indexBanner()
    {
        $data = CustomAd::where('ad_type', 'banner')->paginate(20);
        return view('ads/banner-ad', compact('data'));
    }

    public function indexInter()
    {
        $data = CustomAd::where('ad_type', 'inter')->paginate(20);
        return view('ads/inter-ad', compact('data'));
    }

    function editNetwork(Ads $id)
    {

        return view('ads.adnetwork.edit', ['data' => $id]);
    }

    public function edit(CustomAd $id)
    {

        switch ($id->ad_type) {

            case 'banner':
                return $id;
                break;

            case 'inter':
                return $id;
                break;
        }
    }


    public function indexAds()
    {
        $data = DB::table('ads')->get();
        return view('ads/adnetwork/index', ['ad' => $data]);
    }

    public function updateNetwork(Request $req)
    {
        if (auth()->user()->role_create == 'false') {
            return redirect()->back()->withErrors(['msgError' => env('PERMISSION_ERROR')]);
        }


        $ad = Ads::find($req->id);
        $ad->app_id = $req->app_id;
        
        
        if (isset($req->openad)) {
            $ad->openad = $req->openad;
            $ad->openad_id = $req->openad_id;
        }
        
        $ad->banner = $req->banner;
        if (isset($req->banner_id)) {
            $ad->banner_id = $req->banner_id;
        }
        $ad->interstital = $req->interstital;
        if (isset($req->interstital_id)) {
            $ad->interstital_id = $req->interstital_id;
        }
        $ad->interstital_click = $req->interstital_click;
        $ad->native = $req->native;
        if (isset($req->native_id)) {
            $ad->native_id = $req->native_id;
        }
        $ad->native_posi = $req->native_posi;
        $ad->status = $req->status;
        $res = $ad->save();

        if ($res) {
            return redirect('/ads/adnetwork')->with('success', 'Update Successfully!');
        } else {
            return redirect('/ads/adnetwork')->with('error', 'Something went wrong!');
        }
    }

    public function store(Request $req)
    {

        if (auth()->user()->role_create == 'false') {
            return redirect()->back()->withErrors(['msgError' => env('PERMISSION_ERROR')]);
        }

        if ($req->ad_type == 'banner') {

            $file = $req->file('image');
            $thumb = uniqid() . time() . '.' . $file->getClientOriginalExtension();
            $location = public_path('images/ads/');
            $file->move($location, $thumb);

            $ad = new CustomAd;
            $ad->image = 'images/ads/' . $thumb;
            $ad->ad_type = $req->ad_type;
            $ad->url = $req->url;
            $res = $ad->save();

            if ($res) {
                return redirect('/ads/custom/banner')->with('success', 'Banner Ad Added Successfully!');
            } else {
                return redirect('/ads/custom/banner')->with('error', 'Something went wrong!');
            }
        } else if ($req->ad_type == 'inter') {

            $file = $req->file('image');
            $thumb = uniqid() . time() . '.' . $file->getClientOriginalExtension();
            $location = public_path('images/ads/');
            $file->move($location, $thumb);

            $ad = new CustomAd;
            $ad->image = 'images/ads/' . $thumb;
            $ad->ad_type = $req->ad_type;
            $ad->timer = $req->timer;
            $ad->url = $req->url;
            $res = $ad->save();

            if ($res) {
                return redirect('/ads/interstital')->with('success', 'Banner Ad Added Successfully!');
            } else {
                return redirect('/ads/interstital')->with('error', 'Something went wrong!');
            }
        }
    }

    public function updateAd(Request $req)
    {

        if (auth()->user()->role_edit == 'false') {
            return redirect()->back()->withErrors(['msgError' => env('PERMISSION_ERROR')]);
        }

        if ($req->ad_type == 'banner') {

            if ($req->file('image')) {
                $file = $req->file('image');
                $thumb = uniqid() . time() . '.' . $file->getClientOriginalExtension();
                $location = public_path('images/ads/');
                $file->move($location, $thumb);
                $thumb = 'images/ads/' . $thumb;
                $image_path = $req->oldimage;
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }
            } else {
                $thumb = $req->oldimage;
            }

            $ad = CustomAd::find($req->id);
            $ad->image = $thumb;
            $ad->url = $req->url;
            $res = $ad->save();

            if ($res) {
                return redirect('/ads/custom/banner')->with('success', 'Banner Ad Update Successfully!');
            } else {
                return redirect('/ads/custom/banner')->with('error', 'Something went wrong!');
            }
        } else if ($req->ad_type == 'inter') {

            if ($req->file('image')) {
                $file = $req->file('image');
                $thumb = uniqid() . time() . '.' . $file->getClientOriginalExtension();
                $location = public_path('images/ads/');
                $file->move($location, $thumb);

                $thumb = 'images/ads/' . $thumb;

                $image_path =  $req->oldimage;
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }
            } else {
                $thumb = $req->oldimage;
            }

            $ad = CustomAd::find($req->id);
            $ad->image = $thumb;
            $ad->ad_type = $req->ad_type;
            $ad->timer = $req->timer;
            $ad->url = $req->url;
            $res = $ad->save();
            if ($res) {
                return redirect('/ads/custom/interstital')->with('success', 'Interstital Ad Update Successfully!');
            } else {
                return redirect('/ads/custom/interstital')->with('error', 'Something went wrong!');
            }
        }
    }



    public function deleteNative($id)
    {
        if (auth()->user()->role_delete == 'false') {
            return env('PERMISSION_ERROR');
        }

        $ad = CustomAd::find($id);
        try {

            $image_path = $ad->image;
            if (File::exists($image_path)) {
                File::delete($image_path);
            }
            $ad->delete();
        } catch (\Exception $e) {
            $ad->delete();
        }

        return 1;
    }

    public function NetworkAction(Request $req)
    {

        if (auth()->user()->role_edit == 'false') {
            return env('PERMISSION_ERROR');
        }

         Ads::where('id',$req->id)->update(['status'=>(isset($req->status)) ? ($req->status === 'on') ? 1 : 0  : 0 ]);
         Ads::where('id','!=',$req->id)->update(['status'=>0]);
         return redirect('/ads/adnetwork')->with('success', 'Update Successfully!');
        }

    public function action(Request $req)
    {

        if (auth()->user()->role_edit == 'false') {
            return env('PERMISSION_ERROR');
        }

        if ($req->status == "enable") {
            $update = CustomAd::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = CustomAd::whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }

    public static function updateData($key, $value)
    {
        $path = base_path('.env');

        if (file_exists($path)) {

            file_put_contents($path, str_replace(
                $key . '=' . env($key),
                $key . '=' . $value,
                file_get_contents($path)
            ));
        }
    }
}
